VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   7155
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   9555
   LinkTopic       =   "Form1"
   ScaleHeight     =   7155
   ScaleWidth      =   9555
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdThumbStart 
      Caption         =   "Start Thumbnailing-Test"
      Height          =   345
      Left            =   150
      TabIndex        =   1
      Top             =   60
      Width           =   2085
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   30
      TabIndex        =   0
      Top             =   480
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
   Begin VB.Label lblTiming 
      Caption         =   "Timing-Results: "
      Height          =   255
      Left            =   2340
      TabIndex        =   2
      Top             =   120
      Width           =   7095
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private AsyncReader As cAsyncFileRead

Private Sub Form_Load()
  Caption = "A Thumbnailing-Test against 4 HighRes-JPGs (press the Test-Button)"
  Me.ScaleMode = vbPixels

  'we use a small AsyncRead-Class here, to efficiently decouple the Filesystem-Read of the next file
  'whilst at the same time the current files JPG-content is decoded into a thumbnail
  Set AsyncReader = New cAsyncFileRead
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub cmdThumbStart_Click() 'within here the Thumbnailing-Testloop is performed
Dim i&, T!
Dim oJPG As cJPG, OrigWidth As Long, OrigHeight As Long
Dim FileName As String, NextFileName As String
Dim DesiredWidth As Long, DesiredHeight As Long, ImgLstKey As String, JpgBytes() As Byte

  Cairo.ImageList.RemoveAll 'let's cleanup the Imagelist first for our new testround
  
  
  'we use this "lower-level" JPG-Class-instance here only, to retrieve the original JPG-Dimensions in a fast way
  'The real decoding takes place under the hood (using the same class internally), within the ImageList.Add-Method
  'Also note, that the cJPG-Class (or the ImageList whilst using this class) *never* attempts to read
  '"pre-thumbnailed content" from potential EXIF-data a JPG may contain - the JPG-decoder is fast enough,
  'and will always work against the "real", full JPG-content (of a File or ByteArray-Stream), even when in thumbnail-mode
  Set oJPG = New cJPG

  'let's set the thumbnail-size we wish to store within the ImageList... I choose a
  '"quadratic size", since the ImageList.Add-method also provides a KeepAspectRatio-param, which will automatically
  'fit the loaded Mini-Image within the given bounds below (no matter if the orig. image was "landscape" or not)
  DesiredWidth = 128
  DesiredHeight = 128
  
  T = Timer
  
    For i = 1 To 4
      FileName = App.Path & "\Large" & i & ".jpg" 'define the current Filename, based on Index i
      NextFileName = App.Path & "\Large" & i + 1 & ".jpg" 'already define the next Filename, based on Index i+1
      
      If i < 4 Then 'in case we have not yet reached our last file (in this Demo at index 4), ...
        AsyncReader.GetFileContent FileName, JpgBytes, NextFileName '<--...we feed the AsyncReader per Optional NextFile-param
      
      Else 'and since this is the last file in our small Demo-Loop...
        AsyncReader.GetFileContent FileName, JpgBytes '...we don't need to pass a "next-asyncjob"-Param anymore
      End If
      
      'now let's get the original dimensions of our JPGBytes-Buffer (stored within the ImageList-Key)
      oJPG.GetJPGDimensions VarPtr(JpgBytes(0)), UBound(JpgBytes) + 1, OrigWidth, OrigHeight
      
      'now the pre-concatenation of the ImageList-Key-Parts (for later retrieval and "labeling" in the final rendering-routine)
      ImgLstKey = "Large" & i & ".jpg" 'the "Short-Filename" first (without the Path)
      ImgLstKey = ImgLstKey & " (" & OrigWidth & "x" & OrigHeight & ")" 'this appends the original Dimension-info to our Key

      'and finally the Add-Call which does all "main-work" for us (jpg-decoding + the storage of the Thumbnail-sized Mini-surfaces)
      Cairo.ImageList.AddImage ImgLstKey, JpgBytes, DesiredWidth, DesiredHeight, True   '<-- note the last 3 optional Params, which will FullFill "our Desires" ;-)
    Next i
  
  T = CLng((Timer - T) * 1000) 'scale to msec
  lblTiming.Caption = "Timing-Results: 4 images ""nailed"" after " & T & " msec (about " & T \ 4 & " msec per image)"
  
  
  'Ok, our thumbnail-LoadingLoop is done - now we just "bind" some Controlpoints (one per thumbnail-image)
  'so that you can drag-around the thumbs on the screen later on, for whatever reason ... ;-)
  'The finally triggered Rendering-RefreshRoutine at the end of this Click-Event then draws each
  'thumb from the imagelist, based on the CenterPosition of its (per same Key) "bound ControlPoint"
  Dim X As Double, Y As Double
  
  ucCanvas1.ControlPoints.RemoveAll
  
  For i = 0 To Cairo.ImageList.Count - 1
    ImgLstKey = Cairo.ImageList.KeyByIndex(i) 'just to demonstrate, how KeyRetrieval from the ImageList can be done
    
    X = 40 + Cairo.ImageList.ItemByIndex(i).Width / 2 + (i Mod 2) * 200
    Y = 40 + Cairo.ImageList.ItemByIndex(i).Height / 2 + (i \ 2 Mod 2) * 200
    
    With ucCanvas1.ControlPoints.Add(ImgLstKey, X, Y, &HFFAAAA, , 0.07)  'here we create the Point, using the same Key as the Thumb
      .SetRectangularStyle DesiredWidth, DesiredHeight
    End With
  Next i
  
  Draw ucCanvas1.CC 'now let's trigger the refresh
End Sub


Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim i&, XOffs As Double, YOffs As Double, RCorner As Double
Dim CurKey As String, CurSrf As cCairoSurface, CurControlPoint As cControlPoint

  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint


  For i = 0 To Cairo.ImageList.Count - 1
    CurKey = Cairo.ImageList.KeyByIndex(i)
    
    Set CurSrf = Cairo.ImageList.Item(CurKey)
    Set CurControlPoint = ucCanvas1.ControlPoints.Item(CurKey)
    
    XOffs = CurControlPoint.X - CurSrf.Width / 2
    YOffs = CurControlPoint.Y - CurSrf.Height / 2
    
    'a surrouding rounded-rectangle (slightly larger than the thumb-size)
    RCorner = 6
    CC.RoundedRect XOffs - RCorner, YOffs - RCorner, CurSrf.Width + 2 * RCorner, CurSrf.Height + 2 * RCorner, RCorner
      CC.SetSourceColor &HFFE0D8, 0.4
    CC.Fill True
      CC.SetSourceColor &HFFE0D8, 0.8
    CC.Stroke

    'the "text-label"-rendering (already stored beforehand as the ImageList-Key)
    CC.SelectFont "Tahoma", 8.5, &H404040
    CC.DrawText XOffs - RCorner, 3 + YOffs + CurSrf.Height + RCorner, CurSrf.Width + 2 * RCorner, 50, CurKey, True, vbCenter
    
    'finally the rendering of the thumbnail (within the surrounding Rectangle, drawn above)
    CC.RenderSurfaceContent CurSrf, XOffs, YOffs
  Next i
  
  
  ucCanvas1.Refresh
End Sub
